(function () {
    let app = angular.module('finance', []);


    app.directive('financeOverview', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/finance-overview.html',
            controller: function ($rootScope, $scope, $timeout) {
                let ctrl = this;
                $scope.EmployeeTypes = EmployeeTypeNames;
                this.employees = Helpers.GetAllEmployees(true);

                ctrl.tab = $rootScope.tab || 'budget';
                const transactionsPerPage = 10;
                let loadTransactions = () => {
                    console.log('loadTransactions');
                    let dropAmount = ((ctrl.page - 1) * transactionsPerPage);
                    let totalTransactions = Helpers.Clone($rootScope.settings.transactions).reverse();
                    ctrl.transactions = _.take(_.drop(totalTransactions, dropAmount), transactionsPerPage);

                    let currentDay = GetDateDiffInDays($rootScope.settings.date);
                    ctrl.last30daysContracts = $rootScope.settings.contracts.filter(x => x.status == 'Won' && x.completed && x.completionDay >= currentDay-30);
                    ctrl.incomeByProduct = $rootScope.settings.products.map(x => {
                        return {
                            name: x.name,
                            income: _.sum(x.stats.filter(s => s.day >= currentDay - 30).map(s => s.income))
                        }
                    });
                    ctrl.hostingExpenses = $rootScope.settings.products.map(product => {
                        return {
                            product: product,
                            amount: Helpers.CalculateHostingExpenses(product)
                        }
                    })
                };

                ctrl.page = 1;

                ctrl.activatedBenefits = $rootScope.settings.activatedBenefits.map(benefitId => Database.benefits.find(x => x.id == benefitId));
                
                $scope.$watch('ctrl.page', () => { loadTransactions() });
                $scope.$watchCollection('settings.transactions', () => {
                    loadTransactions();
                });
                loadTransactions();

                ctrl.maxPage = Math.max(1, Math.ceil($rootScope.settings.transactions.length / transactionsPerPage));
                
                $scope.$on(GameEvents.ContractChange, () => {
                    let contracts = Helpers.GetLast30DaysContracts();
                    let groups = _.groupBy(contracts, "companyId");
                    ctrl.clientSales = _.map(groups, (group, key) => {
                        return {
                            client: CompetitorProducts.find(c => c.id == key),
                            contractCount: group.length,
                            income: _.sum(group.map(x => x.winnerOffer.price))
                        }
                    });
                });
                $scope.$broadcast(GameEvents.ContractChange);

                $scope.$on(GameEvents.LoanChange, () => {
                    ctrl.loans = $rootScope.settings.loans.filter(x => x.active);
                });
                $scope.$broadcast(GameEvents.LoanChange);

                ctrl.calculateLoanText = (loan) => {
                    return loan.dailyPayment * Math.min(loan.daysLeft, 30);
                };
                
                ctrl.takeLoan = loan => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('loan_confirm'), () => {
                        loan.active = true;
                        loan.daysLeft = loan.days;
                        loan.amountLeft = loan.dailyPayment * loan.days;
                        $rootScope.settings.balance += loan.amount;
                        PlaySound(Sounds.stamp);
                        $rootScope.$broadcast(GameEvents.LoanChange);
                        wallhack.sendEvent("take_loan", loan.amount);
                        RunAchievementTriggers();

                        $timeout(() => {
                            EmailGenerator.LoanCreated(loan);
                        }, 1500);
                    });
                };

                ctrl.payNow = loan => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('loan_pay_confirm', { amount: numeral(loan.amountLeft).format(Configuration.CURRENCY_FORMAT) }), () => {
                       $rootScope.safeBuy(() => {
                           loan.active = false;
                           $rootScope.$broadcast(GameEvents.LoanChange);
                           wallhack.sendEvent("payback_loan", loan);
                       }, loan.amountLeft, Helpers.GetLocalized('transaction_loan_pay', { provider: loan.provider }));
                    });

                };
            },
            controllerAs: 'ctrl'
        };
    });
})();
